import 'package:photogram_admin_cp/import/core.dart';

class AdminTableStatsDTO {
  var _isDTO = false;

  static const dtoName = 'admin_table_stats_dto';

  /*
  |--------------------------------------------------------------------------
  | data
  |--------------------------------------------------------------------------
  */

  late final String tableName;
  late final String totalRows;
  late final Map<String, String> previousSixMonthStats;
  late final String percentageFromLastMonth;

  /*
  |--------------------------------------------------------------------------
  | getters
  |--------------------------------------------------------------------------
  */

  bool get isDTO => _isDTO;
  bool get isNotDTO => !_isDTO;

  /*
  |--------------------------------------------------------------------------
  | from data
  |--------------------------------------------------------------------------
  */

  AdminTableStatsDTO({
    required this.tableName,
    required this.totalRows,
    required this.previousSixMonthStats,
    required this.percentageFromLastMonth,
  });

  /*
  |--------------------------------------------------------------------------
  | from json
  |--------------------------------------------------------------------------
  */

  AdminTableStatsDTO.fromJson(Map<String, dynamic> jsonMap) {
    /*
    |--------------------------------------------------------------------------
    | try setting all fields:
    |--------------------------------------------------------------------------
    */
    try {
      tableName = jsonMap[keyTableName];
      totalRows = jsonMap[keyTotalRows];
      previousSixMonthStats = Map<String, String>.from(jsonMap[keyPreviousSixMonthStats]);
      percentageFromLastMonth = jsonMap[keyPercentageFromLastMonth];

      _isDTO = true;
    } catch (e) {
      AppLogger.info(e, logType: AppLogType.parser);
    }
  }

  /*
  |--------------------------------------------------------------------------
  | to json
  |--------------------------------------------------------------------------
  */

  Map<String, dynamic> toJson() => {
        keyTableName: tableName,
        keyTotalRows: totalRows,
        keyPreviousSixMonthStats: previousSixMonthStats,
        keyPercentageFromLastMonth: percentageFromLastMonth,
      };

  /*
  |--------------------------------------------------------------------------
  | key maps, warning! must not change
  |--------------------------------------------------------------------------
  */

  static const keyTableName = 'table_name';

  static const keyTotalRows = 'total_rows';

  static const keyPreviousSixMonthStats = 'previous_six_month_stats';

  static const keyPercentageFromLastMonth = 'percentage_from_last_month';
}
